<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwvars wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterWWHelpMergeInfoSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="no" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarProgressProjectGroupsStart" select="wwprogress:Start(count($VarProjectGroups))" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

    <!-- Aborted? -->
    <!--          -->
    <xsl:if test="not(wwprogress:Abort())">
     <!-- Load splits -->
     <!--             -->
     <xsl:for-each select="$GlobalFiles[1]">
      <xsl:variable name="VarSplitsFile" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarSplitsFile/@path)" />

      <!-- Get entry path -->
      <!--                -->
      <xsl:for-each select="$VarSplits[1]">
       <xsl:variable name="VarMergeInfoFile" select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterWWHelpMergeInfoSplitFileType))[1]" />

       <!-- Set entry -->
       <!--           -->
       <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergeInfoFile/@path, $VarProjectGroup/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
       <xsl:if test="not($VarUpToDate)">
        <xsl:variable name="VarResultAsXML">
         <!-- Determine merge info -->
         <!--                       -->
         <xsl:call-template name="WWHelp-Merge-Info">
          <xsl:with-param name="ParamGroupID" select="$VarProjectGroup/@GroupID" />
         </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
        <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarMergeInfoFile/@path, 'Windows-1252', 'text')" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarMergeInfoFile/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarMergeInfoFile/@path)}" projectchecksum="{$VarProjectGroup/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <!-- Group behavior files -->
        <!--                      -->
        <xsl:for-each select="$GlobalInput[1]">
         <xsl:variable name="VarDocumentBehaviorFile" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterBehaviorsType))[1]" />

         <wwfiles:Depends path="{$VarDocumentBehaviorFile/@path}" checksum="{$VarDocumentBehaviorFile/@checksum}" groupID="{$VarDocumentBehaviorFile/@groupID}" documentID="{$VarDocumentBehaviorFile/@documentID}" />
        </xsl:for-each>
       </wwfiles:File>

      </xsl:for-each>
     </xsl:for-each>
    </xsl:if>

    <xsl:variable name="VarProgressProjectGroupEnd" select="wwprogress:End()" />
   </xsl:for-each>

   <xsl:variable name="VarProgressProjectGroupsEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="WWHelp-Merge-Info">
  <xsl:param name="ParamGroupID" />

  <!-- Group Markers -->
  <!--                 -->
  <xsl:variable name="VarGroupMarkersAsXML">
   <xsl:for-each select="$GlobalInput[1]">
    <xsl:variable name="VarDocumentBehaviorFile" select="key('wwfiles-files-by-groupid-type', concat($ParamGroupID, ':', $ParameterBehaviorsType))[1]" />

    <!-- Load behaviors -->
    <!--                -->
    <xsl:variable name="VarDocumentBehaviors" select="wwexsldoc:LoadXMLWithoutResolver($VarDocumentBehaviorFile/@path)" />

    <!-- Emit necessary markers -->
    <!--                        -->
    <xsl:apply-templates select="$VarDocumentBehaviors/wwbehaviors:*" mode="wwmode:merge-info-behaviors" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarGroupMarkers" select="msxsl:node-set($VarGroupMarkersAsXML)/wwbehaviors:Marker" />

  <!-- Merge Order -->
  <!--            -->
  <xsl:variable name="VarMergeOrder">
   <xsl:variable name="VarMergeOrderMarkers" select="$VarGroupMarkers[@behavior = 'wwhelp-merge-order']" />
   <xsl:for-each select="$VarMergeOrderMarkers[last()]">
    <xsl:variable name="VarLastMergeOrderMarker" select="." />

    <xsl:apply-templates select="$VarLastMergeOrderMarker/wwdoc:Marker" mode="wwmode:marker-as-string" />
   </xsl:for-each>
  </xsl:variable>

  <!-- Merge Group -->
  <!--          -->
  <xsl:variable name="VarMergeGroup">
   <xsl:variable name="VarMergeGroupMarkers" select="$VarGroupMarkers[@behavior = 'wwhelp-merge-group']" />
   <xsl:for-each select="$VarMergeGroupMarkers[last()]">
    <xsl:variable name="VarLastMergeGroupMarker" select="." />

    <xsl:apply-templates select="$VarLastMergeGroupMarker/wwdoc:Marker" mode="wwmode:marker-as-string" />
   </xsl:for-each>
  </xsl:variable>

  <!-- Emit if merge order is defined -->
  <!--                                -->
  <xsl:if test="string-length(normalize-space($VarMergeOrder)) &gt; 0">
   <!-- Merge Order -->
   <!--             -->
   <xsl:value-of select="normalize-space($VarMergeOrder)" />
   <xsl:text>&#13;&#10;</xsl:text>

   <!-- Merge Group -->
   <!--             -->
   <xsl:value-of select="normalize-space($VarMergeGroup)" />
   <xsl:text>&#13;&#10;</xsl:text>
  </xsl:if>
 </xsl:template>


 <!-- merge-info-behaviors -->
 <!--                      -->

 <xsl:template match="wwbehaviors:Marker[@behavior = 'wwhelp-merge-order']" mode="wwmode:merge-info-behaviors">
  <xsl:copy-of select="." />
 </xsl:template>


 <xsl:template match="wwbehaviors:Marker[@behavior = 'wwhelp-merge-group']" mode="wwmode:merge-info-behaviors">
  <xsl:copy-of select="." />
 </xsl:template>


 <xsl:template match="*" mode="wwmode:merge-info-behaviors">
  <xsl:apply-templates mode="wwmode:merge-info-behaviors" />
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:merge-info-behaviors">
  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <!-- marker-as-string -->
 <!--                  -->

 <xsl:template match="wwdoc:Text" mode="wwmode:marker-as-string">
  <xsl:value-of select="./@value" />
 </xsl:template>


 <xsl:template match="*" mode="wwmode:marker-as-string">
  <xsl:apply-templates mode="wwmode:marker-as-string" />
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:marker-as-string">
  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>
</xsl:stylesheet>
